﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class PlayerConfiguration : ConfigurationElement
{
    public int LowMoneyCap { get; private set; }
    public int HighMoneyCap { get; private set; }
    public int StartingMoney { get; private set; }
    public float ZPosition { get; private set; }
    public float Scale { get; private set; }

    public PlayerConfiguration() : base("Player")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            LowMoneyCap = Convert.ToInt32(configElem.Element("LowMoneyCap").Value);
            HighMoneyCap = Convert.ToInt32(configElem.Element("HighMoneyCap").Value);
            StartingMoney = Convert.ToInt32(configElem.Element("StartingMoney").Value);
            ZPosition = Convert.ToSingle(configElem.Element("ZPosition").Value);
            Scale = Convert.ToSingle(configElem.Element("Scale").Value);
            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing player configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
